/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.Nullable;

public class SoulStalkBlock
extends Block
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final IntegerProperty SECTION = IntegerProperty.m_61631_((String)"section", (int)0, (int)3);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public SoulStalkBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SECTION, (Comparable)Integer.valueOf(0)));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60918_(SoundType.f_154670_).m_60913_(0.0f, 0.5f).m_60977_().m_60953_(state -> (Integer)state.m_61143_((Property)SECTION) == 3 ? 6 : 0).m_60955_().m_60910_();
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().m_41491_((CreativeModeTab)ColdSweatGroup.COLD_SWEAT);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (level.m_46859_(pos.m_7494_())) {
            int i = 1;
            while (level.m_8055_(pos.m_6625_(i)).m_60734_() == this) {
                ++i;
            }
            if (i < 6 && rand.m_188500_() < 0.05 + CSMath.blend(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get(), Temperature.getTemperatureAt(pos.m_6625_(i - 1), (Level)level), 0.0, 0.95)) {
                int j = (Integer)state.m_61143_((Property)AGE);
                if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                    if (j >= 8) {
                        level.m_46597_(pos.m_7494_(), (BlockState)this.m_49966_().m_61124_((Property)SECTION, (Comparable)Integer.valueOf(3)));
                        int section = rand.m_188500_() < 0.3 ? 2 : 1;
                        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)SECTION, (Comparable)Integer.valueOf(section)), 4);
                    } else {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                }
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        return context.m_43725_().m_8055_(pos.m_7495_()).m_60734_() == this ? (BlockState)this.m_49966_().m_61124_((Property)SECTION, (Comparable)Integer.valueOf(3)) : (context.m_43725_().m_8055_(pos.m_7494_()).m_60795_() && this.m_7898_(this.m_49966_(), (LevelReader)context.m_43725_(), pos) ? this.m_49966_() : null);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState lastState, boolean p_60570_) {
        if (level.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.SOUL_STALK_PLACEABLE_ON) && level.m_8055_(pos.m_7494_()).m_60795_()) {
            level.m_7731_(pos.m_7494_(), (BlockState)ModBlocks.SOUL_STALK.m_49966_().m_61124_((Property)SECTION, (Comparable)Integer.valueOf(3)), 3);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState otherState, LevelAccessor ilevel, BlockPos pos, BlockPos otherPos) {
        if (!this.m_7898_(state, (LevelReader)ilevel, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (direction == Direction.UP) {
            if (otherState.m_60734_() != this) {
                return Blocks.f_50016_.m_49966_();
            }
            if ((Integer)state.m_61143_((Property)SECTION) == 3) {
                return (BlockState)state.m_61124_((Property)SECTION, (Comparable)Integer.valueOf(Math.random() < 0.33 ? 2 : 1));
            }
        }
        return state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, SECTION});
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        return this.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        return below.m_204336_(ModBlockTags.SOUL_STALK_PLACEABLE_ON) || below.m_60734_() == this;
    }
}

